/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.apple.eawt.SystemSleepListener;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import sqlrunner.MacOSXAdapterInterface;
import sqlrunner.Main;
import sqlrunner.MainFrame;

public class MacOSXAdapter
implements MacOSXAdapterInterface {
    private static final Logger logger = Logger.getLogger(MacOSXAdapter.class);

    @Override
    public void setup() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"setup()");
        }
        try {
            Application application = Application.getApplication();
            application.setAboutHandler(new AboutHandler(){

                public void handleAbout(AppEvent.AboutEvent ae) {
                    MainFrame mf;
                    if (Main.startupFinished() && (mf = Main.getActiveMainFrame()) != null) {
                        mf.openAboutDialog();
                    }
                }
            });
            application.addAppEventListener((AppEventListener)new SystemSleepListener(){

                public void systemAwoke(AppEvent.SystemSleepEvent e) {
                }

                public void systemAboutToSleep(AppEvent.SystemSleepEvent e) {
                    logger.info((Object)"System is about to sleep, start closing all connections");
                    Main.disconnect();
                }
            });
            application.addAppEventListener((AppEventListener)new AppReOpenedListener(){

                public void appReOpened(AppEvent.AppReOpenedEvent e) {
                    if (Main.startupFinished()) {
                        MainFrame currActiveMainFrame = Main.getActiveMainFrame();
                        currActiveMainFrame.setState(0);
                        currActiveMainFrame.toFront();
                    }
                }
            });
            application.setPreferencesHandler(new PreferencesHandler(){

                public void handlePreferences(AppEvent.PreferencesEvent ae) {
                    MainFrame mf = Main.getActiveMainFrame();
                    if (Main.startupFinished() && mf != null) {
                        mf.openPreferencesDialog();
                    }
                }
            });
            application.setOpenFileHandler(new OpenFilesHandler(){

                public void openFiles(AppEvent.OpenFilesEvent e) {
                    List listFiles = e.getFiles();
                    this.handleOpenFiles(listFiles);
                }

                private void handleOpenFiles(List<File> listFiles) {
                    boolean firstFile = true;
                    for (File file : listFiles) {
                        logger.info((Object)("handleOpenFile: " + file));
                        if (Main.startupFinished()) {
                            logger.debug((Object)("handleOpenFile call handleFile: " + file));
                            MainFrame currActiveMainFrame = Main.getActiveMainFrame();
                            if (file.getName().toLowerCase().endsWith(".sql")) {
                                logger.debug((Object)"create a new window");
                                MainFrame newMainFrame = Main.createInstance(currActiveMainFrame);
                                logger.debug((Object)("call handle file: " + file));
                                newMainFrame.handleFile(file);
                                continue;
                            }
                            currActiveMainFrame.handleFile(file);
                            continue;
                        }
                        logger.debug((Object)("handleOpenFile set startup file: " + file));
                        if (!firstFile) continue;
                        firstFile = false;
                        Main.setStartupFile(file.getAbsolutePath());
                    }
                }
            });
            application.setQuitHandler(new QuitHandler(){

                public void handleQuitRequestWith(AppEvent.QuitEvent e, QuitResponse resp) {
                    if (Main.startupFinished()) {
                        if (Main.canShutdown()) {
                            Main.shutdown();
                            resp.performQuit();
                        } else {
                            resp.cancelQuit();
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            logger.warn((Object)("setup failed: " + e.getMessage()), e);
        }
    }
}

