/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class Guid {
    private static int counter = 0;
    private static final byte[] shiftab = new byte[]{0, 8, 16, 24, 32, 40, 48, 56};

    private Guid() {
    }

    public static synchronized String nextGuid() {
        try {
            ++counter;
            InetAddress id = InetAddress.getLocalHost();
            byte[] ip = id.getAddress();
            long time = System.currentTimeMillis();
            byte[] guid = new byte[16];
            for (int i = 0; i <= 3; ++i) {
                guid[i] = ip[i];
            }
            Guid.longToBytes(time, guid, 4);
            Guid.intToBytes(counter, guid, 12);
            StringBuffer str = new StringBuffer();
            str.append(Long.toHexString(Guid.bytesToLong(guid, 0)));
            str.append(Long.toHexString(Guid.bytesToLong(guid, 8)));
            return str.toString().toUpperCase();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static long bytesToLong(byte[] ba, int offset) throws IllegalArgumentException {
        if (ba == null) {
            throw new IllegalArgumentException("null as byte array is not allowed");
        }
        long i = 0L;
        for (int j = 0; j < 8; ++j) {
            i |= (long)ba[offset + 7 - j] << shiftab[j] & 255L << shiftab[j];
        }
        return i;
    }

    private static void longToBytes(long i, byte[] ba, int offset) throws IllegalArgumentException {
        if (ba == null) {
            throw new IllegalArgumentException("null as byte array is not allowed");
        }
        for (int j = 0; j < 8; ++j) {
            ba[offset + j] = (byte)(i >>> shiftab[7 - j] & 0xFFL);
        }
    }

    private static void intToBytes(int i, byte[] ba, int offset) throws IllegalArgumentException {
        if (ba == null) {
            throw new IllegalArgumentException("null as byte array is not allowed");
        }
        for (int j = 0; j < 4; ++j) {
            ba[offset + j] = (byte)(i >>> shiftab[3 - j] & 0xFF);
        }
    }
}

