/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.Messages;
import sqlrunner.swinghelper.WindowHelper;

public final class FileInfo
extends JDialog
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private File currentFile = null;
    private long lastModified = 0L;
    private long lastLoaded = 0L;
    private Document currentDocument = null;

    public FileInfo(MainFrame mainFrame) {
        super(mainFrame, "File info", true);
        this.currentFile = mainFrame.getCurrentFile();
        this.lastModified = mainFrame.getCurrentFileLastModified();
        this.lastLoaded = mainFrame.getCurrentFileLoaded();
        this.currentDocument = mainFrame.getDocument();
        this.addKeyListener(this);
        this.setContentPane(this.getJContentPane());
        this.pack();
        WindowHelper.locateWindowAtMiddle(mainFrame, this);
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        SimpleDateFormat sdf = new SimpleDateFormat(MainFrame.getDateFormatMask());
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 13;
        JLabel label = new JLabel(Messages.getString("FileInfo.path"));
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 1;
        gb.gridy = 0;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 17;
        JTextField textField = new JTextField();
        textField.setEditable(false);
        if (this.currentFile != null) {
            textField.setText(this.currentFile.getAbsolutePath());
            textField.setSelectionStart(0);
            textField.setSelectionEnd(textField.getText().length());
            textField.requestFocusInWindow();
        } else {
            textField.setText(Messages.getString("FileInfo.notsaved"));
        }
        contentPane.add((Component)textField, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 1;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 13;
        label = new JLabel(Messages.getString("FileInfo.loadedat"));
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 1;
        gb.gridy = 1;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 17;
        label = new JLabel();
        if (this.lastLoaded > 0L) {
            label.setText(sdf.format(new Date(this.lastLoaded)));
        } else {
            label.setText(null);
        }
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 2;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 13;
        label = new JLabel(Messages.getString("FileInfo.modifiedat"));
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 1;
        gb.gridy = 2;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 17;
        label = new JLabel();
        if (this.lastModified > 0L) {
            label.setText(sdf.format(new Date(Main.getLastModified(this.currentFile))));
        } else {
            label.setText(null);
        }
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 3;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 13;
        label = new JLabel(Messages.getString("FileInfo.filesize"));
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 1;
        gb.gridy = 3;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 17;
        label = new JLabel();
        if (this.currentFile != null) {
            label.setText(String.valueOf(this.currentFile.length()));
        } else {
            label.setText(null);
        }
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 4;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 13;
        label = new JLabel(Messages.getString("FileInfo.countlines"));
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 1;
        gb.gridy = 4;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 17;
        label = new JLabel();
        if (this.currentDocument != null) {
            int countLines = this.currentDocument.getDefaultRootElement().getElementIndex(this.currentDocument.getLength() + 1);
            label.setText(String.valueOf(countLines));
        } else {
            label.setText(null);
        }
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 5;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 13;
        label = new JLabel(Messages.getString("FileInfo.countchars"));
        label.setHorizontalAlignment(4);
        contentPane.add((Component)label, gb);
        gb = new GridBagConstraints();
        gb.gridx = 1;
        gb.gridy = 5;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 17;
        label = new JLabel();
        if (this.currentDocument != null) {
            int countChars = this.currentDocument.getLength();
            label.setText(String.valueOf(countChars));
        } else {
            label.setText(null);
        }
        contentPane.add((Component)label, gb);
        return contentPane;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                this.cancel();
            }
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("close")) {
            this.cancel();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.cancel();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

