/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.DatabaseMetaData;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import sqlrunner.Main;
import sqlrunner.Messages;
import sqlrunner.TextViewer;
import sqlrunner.swinghelper.WindowHelper;

public class DatabaseMetaDataView
extends JFrame
implements TableModel,
ActionListener {
    private static Logger logger = Logger.getLogger(DatabaseMetaData.class);
    private static final long serialVersionUID = 1L;
    private final JPanel jPanel1 = new JPanel();
    private final JPanel jPanel2 = new JPanel();
    private final JButton buttonClose = new JButton();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JTable table = new JTable();
    private transient DatabaseMetaData dbmd;
    private final Vector<Property> model = new Vector();
    private DatabaseMetaDataView self;
    protected EventListenerList listenerList = new EventListenerList();

    public DatabaseMetaDataView(DatabaseMetaData dbmd) {
        this.self = this;
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initComponents();
            this.pack();
            this.setDatabaseMetaData(dbmd);
        }
        catch (Exception e) {
            logger.error((Object)("init gui failed:" + e.getMessage()), (Throwable)e);
        }
    }

    public void setDatabaseMetaData(DatabaseMetaData dbmd_loc) {
        this.dbmd = dbmd_loc;
        this.model.removeAllElements();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    DatabaseMetaDataView.this.viewMetaData();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DatabaseMetaDataView.this.fireTableRowsUpdated(0, DatabaseMetaDataView.this.model.size());
                        }
                    });
                }
                catch (Throwable e) {
                    logger.error((Object)("viewMetaData failed:" + e.getMessage()), e);
                }
            }
        };
        t.start();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void initComponents() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonClose.setText(Messages.getString("DatabaseMetaDataView.close"));
        this.buttonClose.addActionListener(this);
        this.buttonClose.setActionCommand("close");
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setPreferredSize(new Dimension(400, 400));
        this.table.setBackground(Main.info);
        this.table.setToolTipText(null);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new TableMouseListener());
        this.table.registerKeyboardAction(this, "show", KeyStroke.getKeyStroke(10, 0), 0);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.table, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.buttonClose, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("close")) {
            this.dispose();
        } else if (e.getActionCommand().equals("show")) {
            new TextViewer(this.self, this.getValueAt(this.table.getSelectedRow(), 0).toString(), this.getValueAt(this.table.getSelectedRow(), 1).toString());
        }
    }

    private void viewMetaData() {
        String name = "URL";
        try {
            String value;
            try {
                value = this.dbmd.getURL();
                this.setTitle(Messages.getString("DatabaseMetaDataView.metainfofor") + this.dbmd.getURL());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "user-name";
            try {
                value = String.valueOf(this.dbmd.getUserName());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "database-product-name";
            try {
                value = this.dbmd.getDatabaseProductName();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "database-product-version";
            try {
                value = this.dbmd.getDatabaseProductVersion();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "database major version";
            try {
                value = String.valueOf(this.dbmd.getDatabaseMajorVersion());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "database minor version";
            try {
                value = String.valueOf(this.dbmd.getDatabaseMinorVersion());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "driver major version";
            value = String.valueOf(this.dbmd.getDriverMajorVersion());
            this.model.addElement(new Property(name, value));
            name = "driver minor version";
            value = String.valueOf(this.dbmd.getDriverMinorVersion());
            this.model.addElement(new Property(name, value));
            name = "driver name";
            try {
                value = this.dbmd.getDriverName();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "driver version";
            try {
                value = this.dbmd.getDriverVersion();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "all procedures are callable";
            try {
                value = String.valueOf(this.dbmd.allProceduresAreCallable());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "all tables are selectable";
            try {
                value = String.valueOf(this.dbmd.allTablesAreSelectable());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports transactions";
            try {
                value = String.valueOf(this.dbmd.supportsTransactions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports multiple transactions";
            try {
                value = String.valueOf(this.dbmd.supportsMultipleTransactions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports transaction isolation level=TRANSACTION_NONE";
            try {
                value = String.valueOf(this.dbmd.supportsTransactionIsolationLevel(0));
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports transaction isolation level=TRANSACTION_READ_COMMITTED";
            try {
                value = String.valueOf(this.dbmd.supportsTransactionIsolationLevel(2));
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports transaction isolation level=TRANSACTION_READ_UNCOMMITTED";
            try {
                value = String.valueOf(this.dbmd.supportsTransactionIsolationLevel(1));
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports transaction isolation level=TRANSACTION_REPEATABLE_READ";
            try {
                value = String.valueOf(this.dbmd.supportsTransactionIsolationLevel(4));
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports transaction isolation level=TRANSACTION_SERIALIZABLE";
            try {
                value = String.valueOf(this.dbmd.supportsTransactionIsolationLevel(8));
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "default transaction isolation";
            try {
                int iValue = this.dbmd.getDefaultTransactionIsolation();
                switch (iValue) {
                    case 0: {
                        value = "TRANSACTION_NONE";
                        break;
                    }
                    case 2: {
                        value = "TRANSACTION_READ_COMMITTED";
                        break;
                    }
                    case 1: {
                        value = "TRANSACTION_READ_UNCOMMITTED";
                        break;
                    }
                    case 4: {
                        value = "TRANSACTION_REPEATABLE_READ";
                        break;
                    }
                    case 8: {
                        value = "TRANSACTION_SERIALIZABLE";
                    }
                }
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "data definition causes transaction commit";
            try {
                value = String.valueOf(this.dbmd.dataDefinitionCausesTransactionCommit());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "data definition ignored in transactions";
            try {
                value = String.valueOf(this.dbmd.dataDefinitionIgnoredInTransactions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "does max row size include blobs";
            try {
                value = String.valueOf(this.dbmd.doesMaxRowSizeIncludeBlobs());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "catalog-separator";
            try {
                value = this.dbmd.getCatalogSeparator();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "catalog term";
            try {
                value = this.dbmd.getCatalogTerm();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            name = "schema term";
            try {
                value = this.dbmd.getSchemaTerm();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "extra name characters";
            try {
                value = this.dbmd.getExtraNameCharacters();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            name = "search string escape";
            try {
                value = this.dbmd.getSearchStringEscape();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "identifier quote string";
            try {
                value = this.dbmd.getIdentifierQuoteString();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max binary literal length";
            try {
                value = String.valueOf(this.dbmd.getMaxBinaryLiteralLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max catalog name length";
            try {
                value = String.valueOf(this.dbmd.getMaxCatalogNameLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max char literal length";
            try {
                value = String.valueOf(this.dbmd.getMaxCharLiteralLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max column name length";
            try {
                value = String.valueOf(this.dbmd.getMaxColumnNameLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max columns in 'group by'";
            try {
                value = String.valueOf(this.dbmd.getMaxColumnsInGroupBy());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max columns in index";
            try {
                value = String.valueOf(this.dbmd.getMaxColumnsInIndex());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max columns in 'order by'";
            try {
                value = String.valueOf(this.dbmd.getMaxColumnsInOrderBy());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max columns in 'select'";
            try {
                value = String.valueOf(this.dbmd.getMaxColumnsInSelect());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max columns in table";
            try {
                value = String.valueOf(this.dbmd.getMaxColumnsInTable());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max connections";
            try {
                value = String.valueOf(this.dbmd.getMaxConnections());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max cursor name length";
            try {
                value = String.valueOf(this.dbmd.getMaxCursorNameLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max index length";
            try {
                value = String.valueOf(this.dbmd.getMaxIndexLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max procedure name length";
            try {
                value = String.valueOf(this.dbmd.getMaxProcedureNameLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max row size";
            try {
                value = String.valueOf(this.dbmd.getMaxRowSize());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max schema name length";
            try {
                value = String.valueOf(this.dbmd.getMaxSchemaNameLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max statement length";
            try {
                value = String.valueOf(this.dbmd.getMaxStatementLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max statements";
            try {
                value = String.valueOf(this.dbmd.getMaxStatements());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max table name length";
            try {
                value = String.valueOf(this.dbmd.getMaxTableNameLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max tables in select";
            try {
                value = String.valueOf(this.dbmd.getMaxTablesInSelect());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "max user name length";
            try {
                value = String.valueOf(this.dbmd.getMaxUserNameLength());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "numeric functions";
            try {
                value = this.dbmd.getNumericFunctions();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "procedure term";
            try {
                value = String.valueOf(this.dbmd.getProcedureTerm());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "search string escape";
            try {
                value = this.dbmd.getSearchStringEscape();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "additional SQL keywords";
            try {
                value = this.dbmd.getSQLKeywords();
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "string functions";
            try {
                value = String.valueOf(this.dbmd.getStringFunctions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "system functions";
            try {
                value = String.valueOf(this.dbmd.getSystemFunctions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "time date functions";
            try {
                value = String.valueOf(this.dbmd.getTimeDateFunctions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "is catalog at start";
            try {
                value = String.valueOf(this.dbmd.isCatalogAtStart());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "is read only";
            try {
                value = String.valueOf(this.dbmd.isReadOnly());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "null plus non null is null";
            try {
                value = String.valueOf(this.dbmd.nullPlusNonNullIsNull());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "nulls are sorted at end";
            try {
                value = String.valueOf(this.dbmd.nullsAreSortedAtEnd());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "nulls are sorted at start";
            try {
                value = String.valueOf(this.dbmd.nullsAreSortedAtStart());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "nulls are sorted high";
            try {
                value = String.valueOf(this.dbmd.nullsAreSortedHigh());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "nulls are sorted low";
            try {
                value = String.valueOf(this.dbmd.nullsAreSortedLow());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "stores lower case identifiers";
            try {
                value = String.valueOf(this.dbmd.storesLowerCaseIdentifiers());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "stores lower case quoted identifiers";
            try {
                value = String.valueOf(this.dbmd.storesLowerCaseQuotedIdentifiers());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "stores mixed case identifiers";
            try {
                value = String.valueOf(this.dbmd.storesMixedCaseIdentifiers());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "stores mixed case quoted identifiers";
            try {
                value = String.valueOf(this.dbmd.storesMixedCaseQuotedIdentifiers());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "stores mixed case quoted identifiers";
            try {
                value = String.valueOf(this.dbmd.storesMixedCaseQuotedIdentifiers());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "stores upper case identifiers";
            try {
                value = String.valueOf(this.dbmd.storesUpperCaseIdentifiers());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "stores upper case quoted identifiers";
            try {
                value = String.valueOf(this.dbmd.storesUpperCaseQuotedIdentifiers());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports alter table with add column";
            try {
                value = String.valueOf(this.dbmd.supportsAlterTableWithAddColumn());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports alter table with drop column";
            try {
                value = String.valueOf(this.dbmd.supportsAlterTableWithDropColumn());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports ANSI92 entry level SQL";
            try {
                value = String.valueOf(this.dbmd.supportsANSI92EntryLevelSQL());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports ANSI92 full SQL";
            try {
                value = String.valueOf(this.dbmd.supportsANSI92FullSQL());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports ANSI92 intermediate SQL";
            try {
                value = String.valueOf(this.dbmd.supportsANSI92IntermediateSQL());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports batch updates";
            try {
                value = String.valueOf(this.dbmd.supportsBatchUpdates());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports catalogs in data-manipulation";
            try {
                value = String.valueOf(this.dbmd.supportsCatalogsInDataManipulation());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports catalogs in index-definitions";
            try {
                value = String.valueOf(this.dbmd.supportsCatalogsInIndexDefinitions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports catalogs in privilege-definitions";
            try {
                value = String.valueOf(this.dbmd.supportsCatalogsInPrivilegeDefinitions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports catalogs in procedure-calls";
            try {
                value = String.valueOf(this.dbmd.supportsCatalogsInProcedureCalls());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports catalogs in table-definitions";
            try {
                value = String.valueOf(this.dbmd.supportsCatalogsInTableDefinitions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports schemas in data-manipulation";
            try {
                value = String.valueOf(this.dbmd.supportsSchemasInDataManipulation());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports schemas in privilege-definitions";
            try {
                value = String.valueOf(this.dbmd.supportsSchemasInPrivilegeDefinitions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports schemas in index-definitions";
            try {
                value = String.valueOf(this.dbmd.supportsSchemasInIndexDefinitions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports schemas in procedure-calls";
            try {
                value = String.valueOf(this.dbmd.supportsSchemasInProcedureCalls());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports schemas in table-definitions?\t";
            try {
                value = String.valueOf(this.dbmd.supportsSchemasInTableDefinitions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports Column aliasing";
            try {
                value = String.valueOf(this.dbmd.supportsColumnAliasing());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports convert";
            try {
                value = String.valueOf(this.dbmd.supportsConvert());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports core SQL grammar";
            try {
                value = String.valueOf(this.dbmd.supportsCoreSQLGrammar());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports correlated subqueries";
            try {
                value = String.valueOf(this.dbmd.supportsCorrelatedSubqueries());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports data-definition- and data-manipulation-transactions";
            try {
                value = String.valueOf(this.dbmd.supportsDataDefinitionAndDataManipulationTransactions());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports data-manipulation-transactions only";
            try {
                value = String.valueOf(this.dbmd.supportsDataManipulationTransactionsOnly());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports different table correlation-names";
            try {
                value = String.valueOf(this.dbmd.supportsDifferentTableCorrelationNames());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports expressions in 'order by'";
            try {
                value = String.valueOf(this.dbmd.supportsExpressionsInOrderBy());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports extended SQL grammar";
            try {
                value = String.valueOf(this.dbmd.supportsExtendedSQLGrammar());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports full outer-joins";
            try {
                value = String.valueOf(this.dbmd.supportsFullOuterJoins());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports 'group by'";
            try {
                value = String.valueOf(this.dbmd.supportsGroupBy());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports 'group by' beyond select";
            try {
                value = String.valueOf(this.dbmd.supportsGroupByBeyondSelect());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports 'group by' unrelated";
            try {
                value = String.valueOf(this.dbmd.supportsGroupByUnrelated());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports integrity enhancement facility";
            try {
                value = String.valueOf(this.dbmd.supportsIntegrityEnhancementFacility());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports like escape clause";
            try {
                value = String.valueOf(this.dbmd.supportsLikeEscapeClause());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports limited outer-joins";
            try {
                value = String.valueOf(this.dbmd.supportsLimitedOuterJoins());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports minimum SQL grammar";
            try {
                value = String.valueOf(this.dbmd.supportsMinimumSQLGrammar());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports mixed case identifiers";
            try {
                value = String.valueOf(this.dbmd.supportsMixedCaseIdentifiers());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports mixed case quoted identifiers";
            try {
                value = String.valueOf(this.dbmd.supportsMixedCaseQuotedIdentifiers());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports multiple resultSets";
            try {
                value = String.valueOf(this.dbmd.supportsMultipleResultSets());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports non nullable columns";
            try {
                value = String.valueOf(this.dbmd.supportsNonNullableColumns());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports open cursors across commit";
            try {
                value = String.valueOf(this.dbmd.supportsOpenCursorsAcrossCommit());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports open cursors across rollback";
            try {
                value = String.valueOf(this.dbmd.supportsOpenCursorsAcrossRollback());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports open statements across commit";
            try {
                value = String.valueOf(this.dbmd.supportsOpenStatementsAcrossCommit());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports open statements across rollback";
            try {
                value = String.valueOf(this.dbmd.supportsOpenStatementsAcrossRollback());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports 'order by' unrelated";
            try {
                value = String.valueOf(this.dbmd.supportsOrderByUnrelated());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports outer joins";
            try {
                value = String.valueOf(this.dbmd.supportsOuterJoins());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports positioned delete";
            try {
                value = String.valueOf(this.dbmd.supportsPositionedDelete());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports positioned update";
            try {
                value = String.valueOf(this.dbmd.supportsPositionedUpdate());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports select for update";
            try {
                value = String.valueOf(this.dbmd.supportsSelectForUpdate());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports stored procedures";
            try {
                value = String.valueOf(this.dbmd.supportsStoredProcedures());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports subqueries in comparisons";
            try {
                value = String.valueOf(this.dbmd.supportsSubqueriesInComparisons());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports subqueries in exists";
            try {
                value = String.valueOf(this.dbmd.supportsSubqueriesInExists());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports subqueries in ins";
            try {
                value = String.valueOf(this.dbmd.supportsSubqueriesInIns());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports subqueries in quantifieds?\t";
            try {
                value = String.valueOf(this.dbmd.supportsSubqueriesInQuantifieds());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports table correlation-names";
            try {
                value = String.valueOf(this.dbmd.supportsTableCorrelationNames());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports union";
            try {
                value = String.valueOf(this.dbmd.supportsUnion());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "supports union all";
            try {
                value = String.valueOf(this.dbmd.supportsUnionAll());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "uses local file per table";
            try {
                value = String.valueOf(this.dbmd.usesLocalFilePerTable());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
            name = "uses local files";
            try {
                value = String.valueOf(this.dbmd.usesLocalFiles());
            }
            catch (Exception e) {
                value = e.getMessage();
                if (value == null || value.length() == 0) {
                    value = e.toString();
                }
            }
            catch (AbstractMethodError ame) {
                value = "information not implemented";
            }
            this.model.addElement(new Property(name, value));
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(this, Messages.getString("DatabaseMetaDataView.errornull"), Messages.getString("DatabaseMetaDataView.readdata"), 0);
        }
        this.table.setModel(this);
    }

    @Override
    public int getRowCount() {
        return this.model.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return Messages.getString("DatabaseMetaDataView.name");
        }
        return Messages.getString("DatabaseMetaDataView.value");
    }

    public Class<String> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.model.elementAt((int)rowIndex).name;
        }
        return this.model.elementAt((int)rowIndex).value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    private static class Property {
        String name;
        String value;

        Property(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        TableMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2) {
                new TextViewer(DatabaseMetaDataView.this.self, DatabaseMetaDataView.this.getValueAt(DatabaseMetaDataView.this.table.getSelectedRow(), 0).toString(), DatabaseMetaDataView.this.getValueAt(DatabaseMetaDataView.this.table.getSelectedRow(), 1).toString());
            }
        }
    }
}

