/*
 * Decompiled with CFR 0.152.
 */
package de.cimt.talendcomp.tabletransfer;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSessionPool;
import dbtools.SQLPSParam;
import dbtools.SQLStatement;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.generator.SQLCodeGenerator;
import sqlrunner.text.StringReplacer;

public final class TableTransfer {
    private Logger logger = Logger.getLogger(TableTransfer.class);
    private Properties properties = new Properties();
    private ConnectionDescription sourceConnDesc;
    private ConnectionDescription targetConnDesc;
    private Connection sourceConnection;
    private Connection targetConnection;
    private SQLStatement targetInsertStatement;
    private PreparedStatement sourcePSSelect;
    private PreparedStatement targetPSInsert;
    private SQLDataModel sourceModel;
    private SQLDataModel targetModel;
    private SQLTable sourceTable;
    private String sourceQuery;
    private SQLTable targetTable;
    private static final int RETURN_CODE_OK = 0;
    private static final int RETURN_CODE_ERROR = 1;
    private static final int RETURN_CODE_WARN = 5;
    private int returnCode = 0;
    private String errorMessage;
    private Exception errorException;
    private BlockingQueue<Object> queue;
    private final Object closeFlag = new String("The End");
    private List<String> listResultSetFieldNames;
    private Thread readerThread;
    private Thread writerThread;
    private Thread readWriteThread;
    private volatile int countInserts = 0;
    private volatile int countRead = 0;
    private volatile boolean running = false;
    private long startTime;
    public static final String SOURCE_URL = "source.url";
    public static final String SOURCE_USER = "source.user";
    public static final String SOURCE_PASSWORD = "source.password";
    public static final String SOURCE_DRIVER = "source.driverClass";
    public static final String SOURCE_FETCHSIZE = "source.fetchSize";
    public static final String SOURCE_PROPERTIES = "source.properties";
    public static final String SOURCE_TABLE = "source.table";
    public static final String SOURCE_WHERE = "source.whereClause";
    public static final String SOURCE_QUERY = "source.query";
    public static final String TARGET_URL = "target.url";
    public static final String TARGET_USER = "target.user";
    public static final String TARGET_PASSWORD = "target.password";
    public static final String TARGET_DRIVER = "target.driverClass";
    public static final String TARGET_BATCHSIZE = "target.batchSize";
    public static final String TARGET_TABLE = "target.table";
    public static final String TARGET_PROPERTIES = "target.properties";
    public static final String DIE_ON_ERROR = "abortIfErrors";
    private boolean dieOnError = true;
    private boolean initialized = false;
    private List<String> excludeFieldList = new ArrayList<String>();

    public void addExcludeField(String name) {
        if (name != null && !name.trim().isEmpty()) {
            this.excludeFieldList.add(name.trim());
        }
    }

    public final int getCurrentCountInserts() {
        return this.countInserts;
    }

    public final int getCurrentCountReads() {
        return this.countRead;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public static final Connection createConnection(ConnectionDescription cd) throws Exception {
        Class.forName(cd.getDriverClassName());
        Connection conn = DriverManager.getConnection(cd.getUrl(), TableTransfer.getConnectionProperties(cd));
        return conn;
    }

    private static final Properties getConnectionProperties(ConnectionDescription cd) {
        Properties properties = new Properties();
        if (cd.getPropertiesString() != null) {
            StringTokenizer st = new StringTokenizer(cd.getPropertiesString(), ";");
            String token = null;
            String key = null;
            String value = null;
            int pos = 0;
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                pos = token.indexOf(61);
                if (pos == -1) continue;
                key = token.substring(0, pos).trim();
                value = token.substring(pos + 1).trim();
                if (key.length() <= 0 || value.length() <= 0) continue;
                properties.put(key, value);
            }
        }
        properties.put("user", cd.getUser());
        properties.put("password", cd.getPasswd());
        return properties;
    }

    public final void execute() throws Exception {
        if (!this.initialized) {
            throw new Exception("Not initialized!");
        }
        this.running = true;
        this.countRead = 0;
        this.countInserts = 0;
        this.startReading();
        this.startWriting();
    }

    public final void executeSynchron() throws Exception {
        if (!this.initialized) {
            throw new Exception("Not initialized!");
        }
        this.running = true;
        this.countRead = 0;
        this.countInserts = 0;
        this.startReadWriteSynchron();
    }

    private final void startReadWriteSynchron() {
        this.readWriteThread = new Thread(){

            @Override
            public void run() {
                TableTransfer.this.readWriteSynchron();
            }
        };
        this.readWriteThread.setDaemon(false);
        this.readWriteThread.start();
    }

    private final void startReading() {
        this.readerThread = new Thread(){

            @Override
            public void run() {
                TableTransfer.this.read();
            }
        };
        this.readerThread.setDaemon(false);
        this.readerThread.start();
    }

    private final void startWriting() {
        this.writerThread = new Thread(){

            @Override
            public void run() {
                TableTransfer.this.write();
            }
        };
        this.writerThread.setDaemon(false);
        this.writerThread.start();
    }

    public final void stop() {
        if (this.readerThread != null) {
            this.readerThread.interrupt();
        }
        if (this.writerThread != null) {
            this.writerThread.interrupt();
        }
    }

    public final void disconnect() {
        DatabaseSessionPool.close((String)this.sourceConnDesc.getUniqueId());
        DatabaseSessionPool.close((String)this.targetConnDesc.getUniqueId());
        if (this.sourceConnection != null) {
            try {
                this.sourceConnection.close();
            }
            catch (SQLException e) {
                this.logger.error("disconnect from source failed: " + e.getMessage(), e);
            }
        }
        if (this.targetConnection != null) {
            try {
                this.targetConnection.close();
            }
            catch (SQLException e) {
                this.logger.error("disconnect from target failed: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void read() {
        if (this.sourceTable != null) {
            this.logger.info("Start fetch data from source table " + this.sourceTable.getAbsoluteName());
        } else {
            this.logger.info("Start fetch data from source query " + this.sourceQuery);
        }
        try {
            ResultSet rs = this.sourcePSSelect.executeQuery();
            this.logger.info("Analyse result set...");
            ResultSetMetaData rsMeta = rs.getMetaData();
            int countColumns = rsMeta.getColumnCount();
            this.listResultSetFieldNames = new ArrayList<String>(countColumns);
            for (int i = 1; i <= countColumns; ++i) {
                this.listResultSetFieldNames.add(rsMeta.getColumnName(i).toLowerCase());
            }
            this.logger.info("Start fetching data...");
            this.startTime = System.currentTimeMillis();
            while (rs.next()) {
                Object[] row = new Object[countColumns];
                this.fillRow(row, rs);
                this.queue.put(row);
                ++this.countRead;
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
            rs.close();
            this.logger.info("Finished fetch data from source table " + this.sourceTable.getAbsoluteName() + " count read:" + this.countRead);
        }
        catch (SQLException e) {
            String message = e.getMessage();
            SQLException en = e.getNextException();
            if (en != null) {
                message = "\nNext Exception:" + en.getMessage();
            }
            this.error("read failed in line number " + this.countRead + " message:" + message, e);
            this.returnCode = 1;
        }
        catch (InterruptedException ie) {
            this.error("read interrupted (send data sets)", ie);
            this.returnCode = 1;
        }
        finally {
            try {
                this.queue.put(this.closeFlag);
            }
            catch (InterruptedException e) {
                this.error("read interrupted (send close flag)", e);
                this.returnCode = 1;
            }
            try {
                if (!this.sourceConnection.getAutoCommit()) {
                    this.sourceConnection.commit();
                }
                this.sourcePSSelect.close();
            }
            catch (SQLException e) {}
        }
    }

    private final void fillRow(Object[] row, ResultSet rs) throws SQLException {
        for (int i = 0; i < row.length; ++i) {
            row[i] = rs.getObject(i + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readWriteSynchron() {
        block38: {
            this.logger.info("Start reading+writing data syncronously...");
            if (this.sourceTable != null) {
                this.logger.info("Start fetch data from source table " + this.sourceTable.getAbsoluteName());
            } else {
                this.logger.info("Start fetch data from source query " + this.sourceQuery);
            }
            int batchSize = Integer.parseInt(this.properties.getProperty(TARGET_BATCHSIZE, "1"));
            int currentBatchCount = 0;
            boolean autocommitTemp = false;
            try {
                autocommitTemp = this.targetConnection.getAutoCommit();
            }
            catch (SQLException e2) {
                this.logger.warn("Failed to detect autocommit state: " + e2.getMessage(), e2);
            }
            boolean autocommit = autocommitTemp;
            try {
                ResultSet rs = this.sourcePSSelect.executeQuery();
                this.logger.info("Analyse result set...");
                ResultSetMetaData rsMeta = rs.getMetaData();
                int countColumns = rsMeta.getColumnCount();
                this.listResultSetFieldNames = new ArrayList<String>(countColumns);
                for (int i = 1; i <= countColumns; ++i) {
                    this.listResultSetFieldNames.add(rsMeta.getColumnName(i).toLowerCase());
                }
                this.logger.info("Start fetching data...");
                this.startTime = System.currentTimeMillis();
                while (rs.next()) {
                    block37: {
                        Object[] row = new Object[countColumns];
                        this.fillRow(row, rs);
                        ++this.countRead;
                        try {
                            this.prepareInsertStatement(row);
                            this.targetPSInsert.addBatch();
                            ++this.countInserts;
                            if (++currentBatchCount != batchSize) break block37;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("write execute insert batch");
                            }
                            this.targetPSInsert.executeBatch();
                            if (!autocommit) {
                                this.targetConnection.commit();
                            }
                            currentBatchCount = 0;
                        }
                        catch (SQLException sqle) {
                            this.error("write failed in line number " + this.countInserts + " message:" + sqle.getMessage(), sqle);
                            if (sqle.getNextException() != null) {
                                this.error("write failed embedded error:" + sqle.getNextException().getMessage(), sqle.getNextException());
                            }
                            if (this.dieOnError) {
                                this.returnCode = 1;
                                try {
                                    if (autocommit) break;
                                    this.targetConnection.rollback();
                                }
                                catch (SQLException e) {
                                    this.logger.error("write rollback failed: " + e.getMessage(), e);
                                }
                                break;
                            }
                            try {
                                if (!autocommit) {
                                    this.targetConnection.commit();
                                }
                            }
                            catch (SQLException e) {
                                this.logger.error("write commit failed: " + e.getMessage(), e);
                            }
                        }
                        catch (Exception e1) {
                            this.returnCode = 1;
                            this.error("write failed:" + e1.getMessage(), e1);
                            break;
                        }
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
                rs.close();
                this.logger.info("Finished fetching data from source table " + this.sourceTable.getAbsoluteName() + " count read:" + this.countRead);
                if (currentBatchCount <= 0 || this.returnCode != 0) break block38;
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("write execute final insert batch");
                    }
                    this.targetPSInsert.executeBatch();
                    if (!autocommit) {
                        this.targetConnection.commit();
                    }
                    currentBatchCount = 0;
                }
                catch (SQLException sqle) {
                    this.returnCode = 1;
                    this.error("write failed executing last batch message:" + sqle.getMessage(), sqle);
                    if (sqle.getNextException() != null) {
                        this.error("write failed embedded error:" + sqle.getNextException().getMessage(), sqle.getNextException());
                    }
                    try {
                        this.targetConnection.rollback();
                    }
                    catch (SQLException e) {
                        this.logger.error("write rollback failed:" + e.getMessage(), e);
                    }
                }
            }
            catch (SQLException e) {
                this.error("read failed in line number " + this.countRead + " message:" + e.getMessage(), e);
                this.returnCode = 1;
            }
            finally {
                try {
                    if (!this.sourceConnection.getAutoCommit()) {
                        this.sourceConnection.commit();
                    }
                    this.sourcePSSelect.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write() {
        block32: {
            this.logger.info("Start writing data into target table " + this.targetTable.getAbsoluteName());
            int batchSize = Integer.parseInt(this.properties.getProperty(TARGET_BATCHSIZE, "1"));
            int currentBatchCount = 0;
            try {
                boolean autocommitTemp = false;
                try {
                    autocommitTemp = this.targetConnection.getAutoCommit();
                }
                catch (SQLException e2) {
                    this.logger.warn("Failed to detect autocommit state: " + e2.getMessage(), e2);
                }
                boolean autocommit = autocommitTemp;
                boolean endFlagReceived = false;
                block21: while (!endFlagReceived) {
                    try {
                        ArrayList queueObjects = new ArrayList(batchSize);
                        this.queue.drainTo(queueObjects, batchSize);
                        for (Object item : queueObjects) {
                            if (item == this.closeFlag) {
                                this.logger.info("write finished");
                                endFlagReceived = true;
                                continue block21;
                            }
                            this.prepareInsertStatement((Object[])item);
                            this.targetPSInsert.addBatch();
                            ++this.countInserts;
                            if (++currentBatchCount == batchSize) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("write execute insert batch");
                                }
                                this.targetPSInsert.executeBatch();
                                if (!autocommit) {
                                    this.targetConnection.commit();
                                }
                                currentBatchCount = 0;
                            }
                            if (!Thread.currentThread().isInterrupted()) continue;
                            continue block21;
                        }
                    }
                    catch (InterruptedException e) {
                        this.error("write interrupted in line " + this.countInserts, e);
                        this.returnCode = 1;
                        break;
                    }
                    catch (SQLException sqle) {
                        this.error("write failed in line number " + this.countInserts + " message:" + sqle.getMessage(), sqle);
                        if (sqle.getNextException() != null) {
                            this.error("Embedded error:" + sqle.getNextException().getMessage(), sqle.getNextException());
                        }
                        if (this.dieOnError) {
                            this.returnCode = 1;
                            try {
                                if (autocommit) break;
                                this.targetConnection.rollback();
                            }
                            catch (SQLException e) {
                                this.logger.error("write rollback failed: " + e.getMessage(), e);
                            }
                            break;
                        }
                        try {
                            if (autocommit) continue;
                            this.targetConnection.commit();
                        }
                        catch (SQLException e) {
                            this.logger.error("write commit failed: " + e.getMessage(), e);
                        }
                    }
                    catch (Exception e1) {
                        this.returnCode = 1;
                        this.error("write failed:" + e1.getMessage(), e1);
                        break;
                    }
                }
                if (currentBatchCount <= 0 || this.returnCode != 0) break block32;
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("write execute final insert batch");
                    }
                    this.targetPSInsert.executeBatch();
                    if (!autocommit) {
                        this.targetConnection.commit();
                    }
                    currentBatchCount = 0;
                }
                catch (SQLException sqle) {
                    this.returnCode = 1;
                    this.error("write failed executing last batch message:" + sqle.getMessage(), sqle);
                    if (sqle.getNextException() != null) {
                        this.error("write failed embedded error:" + sqle.getNextException().getMessage(), sqle.getNextException());
                    }
                    try {
                        this.targetConnection.rollback();
                    }
                    catch (SQLException e) {
                        this.logger.error("write rollback failed:" + e.getMessage(), e);
                    }
                }
            }
            finally {
                try {
                    this.targetPSInsert.close();
                }
                catch (SQLException sQLException) {}
                this.running = false;
                this.logger.info("Finished write data into target table " + this.targetTable.getAbsoluteName() + " count inserts:" + this.countInserts);
            }
        }
    }

    private final Object getRowValue(String columnName, Object[] row) {
        int index = this.listResultSetFieldNames.indexOf(columnName.toLowerCase());
        if (index != -1) {
            return row[index];
        }
        return null;
    }

    private final void prepareInsertStatement(Object[] row) throws Exception {
        for (SQLPSParam p : this.targetInsertStatement.getParams()) {
            Object value = this.getRowValue(p.getName(), row);
            if (value != null) {
                this.targetPSInsert.setObject(p.getIndex(), value);
                continue;
            }
            this.targetPSInsert.setNull(p.getIndex(), this.targetTable.getField(p.getName()).getType());
        }
    }

    public final void connect() throws Exception {
        this.connectSource();
        this.connectTarget();
    }

    public final void executeSQLOnTarget(String sqlStatement) throws Exception {
        if (this.targetConnection == null || this.targetConnection.isClosed()) {
            throw new Exception("executeSQLOnTarget failed because target connection is null or closed");
        }
        try {
            Statement stat = this.targetConnection.createStatement();
            stat.execute(sqlStatement);
            stat.close();
        }
        catch (SQLException sqle) {
            this.logger.error("executeSQLOnTarget sql=" + sqlStatement + " failed: " + sqle.getMessage(), sqle);
            throw sqle;
        }
    }

    public void commitSource() throws SQLException {
        this.sourceConnection.commit();
    }

    public void commitTarget() throws SQLException {
        this.targetConnection.commit();
    }

    public final void setupExecute() throws Exception {
        this.createSourceSelectStatement();
        this.createTargetInsertStatement();
        int batchSize = Integer.parseInt(this.properties.getProperty(TARGET_BATCHSIZE, "100"));
        int fetchSize = Integer.parseInt(this.properties.getProperty(SOURCE_FETCHSIZE, "100"));
        int queueSize = Math.max(batchSize, fetchSize) + 100;
        this.queue = new LinkedBlockingQueue<Object>(queueSize);
        this.dieOnError = Boolean.parseBoolean(this.properties.getProperty(DIE_ON_ERROR, "true"));
        this.initialized = true;
    }

    private final SQLTable getSourceSQLTable() throws Exception {
        String tableAndSchemaName = this.properties.getProperty(SOURCE_TABLE);
        if (this.sourceTable == null || !this.sourceTable.getAbsoluteName().equalsIgnoreCase(tableAndSchemaName)) {
            SQLSchema schema;
            String schemaName = this.getSchemaName(tableAndSchemaName);
            if (schemaName == null) {
                schemaName = this.sourceModel.getLoginSchemaName();
            }
            if ((schema = this.sourceModel.getSchema(schemaName)) == null) {
                throw new Exception("getSourceTable failed: schema " + schemaName + " not available");
            }
            String tableName = this.getTableName(tableAndSchemaName);
            this.sourceTable = schema.getTable(tableName);
            if (this.sourceTable == null) {
                throw new Exception("getSourceTable failed: table " + tableAndSchemaName + " not available");
            }
            for (String exclFieldName : this.excludeFieldList) {
                SQLField field = this.sourceTable.getField(exclFieldName);
                if (field == null) continue;
                this.sourceTable.removeSQLField(field);
            }
        }
        return this.sourceTable;
    }

    private final SQLTable getTargetSQLTable() throws Exception {
        String tableAndSchemaName = this.properties.getProperty(TARGET_TABLE);
        if (this.targetTable == null || !this.targetTable.getAbsoluteName().equalsIgnoreCase(tableAndSchemaName)) {
            SQLSchema schema;
            String schemaName = this.getSchemaName(tableAndSchemaName);
            if (schemaName == null) {
                schemaName = this.targetModel.getLoginSchemaName();
            }
            if ((schema = this.targetModel.getSchema(schemaName)) == null) {
                throw new Exception("getTargetTable failed: schema " + schemaName + " not available");
            }
            String tableName = this.getTableName(tableAndSchemaName);
            this.targetTable = schema.getTable(tableName);
            if (this.targetTable == null) {
                throw new Exception("getTargetTable failed: table " + tableAndSchemaName + " not available");
            }
            for (String exclFieldName : this.excludeFieldList) {
                SQLField field = this.targetTable.getField(exclFieldName);
                if (field == null) continue;
                this.targetTable.removeSQLField(field);
            }
        }
        return this.targetTable;
    }

    private PreparedStatement createSourceSelectStatement() throws Exception {
        this.sourceQuery = this.properties.getProperty(SOURCE_QUERY);
        if (this.sourceQuery == null) {
            this.sourceQuery = SQLCodeGenerator.buildSelectStatement((SQLTable)this.getSourceSQLTable(), (boolean)true) + this.buildSourceWhereSQL();
            this.properties.put(SOURCE_QUERY, this.sourceQuery);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("createSourceSelectStatement SQL:" + this.sourceQuery);
        }
        this.sourcePSSelect = this.sourceConnection.prepareStatement(this.sourceQuery, 1003, 1007);
        int fetchSize = this.getFetchSize();
        if (fetchSize > 0) {
            this.sourcePSSelect.setFetchSize(fetchSize);
        }
        return this.sourcePSSelect;
    }

    private int getFetchSize() {
        int fetchSize = 0;
        try {
            fetchSize = Integer.parseInt(this.properties.getProperty(SOURCE_FETCHSIZE, "0"));
        }
        catch (Exception e) {
            this.logger.warn("getFetchSize failed: " + e.getMessage(), e);
        }
        return fetchSize;
    }

    private PreparedStatement createTargetInsertStatement() throws Exception {
        this.targetInsertStatement = SQLCodeGenerator.buildPSInsertSQLStatement((SQLTable)this.getTargetSQLTable(), (boolean)true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("createTargetInsertStatement SQL:" + this.targetInsertStatement.getSQL());
        }
        this.targetPSInsert = this.targetConnection.prepareStatement(this.targetInsertStatement.getSQL());
        return this.targetPSInsert;
    }

    private final String buildSourceWhereSQL() {
        String where = this.properties.getProperty(SOURCE_WHERE);
        if (where != null && !where.trim().isEmpty()) {
            if ((where = this.replacePlaceholders(where)).startsWith("where")) {
                return " " + where;
            }
            return " where " + where;
        }
        return "";
    }

    private final String replacePlaceholders(String stringWithPlaceholders) {
        boolean ready = false;
        ArrayList<String> listPlaceHolders = new ArrayList<String>();
        int p0 = -1;
        int p1 = -1;
        while (!ready) {
            p0 = stringWithPlaceholders.indexOf(123, p1 + 1);
            p1 = stringWithPlaceholders.indexOf(125, p0 + 1);
            if (p0 != -1 && p1 != -1) {
                String key = stringWithPlaceholders.substring(p0 + 1, p1);
                listPlaceHolders.add(key);
                continue;
            }
            ready = true;
        }
        StringReplacer sr = new StringReplacer(stringWithPlaceholders);
        for (String key : listPlaceHolders) {
            String value = this.properties.getProperty(key);
            if (value == null) {
                this.logger.warn("replacePlaceholders for string " + stringWithPlaceholders + " failed in key:" + key + " reason: missing value");
                this.returnCode = 5;
                value = "";
            }
            sr.replace("{" + key + "}", value.trim());
        }
        return sr.getResultText();
    }

    private final String getSchemaName(String schemaAndTable) {
        int pos = schemaAndTable.indexOf(46);
        if (pos > 0) {
            return schemaAndTable.substring(0, pos);
        }
        return null;
    }

    private final String getTableName(String schemaAndTable) {
        int pos = schemaAndTable.indexOf(46);
        if (pos > 0) {
            return schemaAndTable.substring(pos + 1, schemaAndTable.length());
        }
        return null;
    }

    private final void connectSource() throws Exception {
        String user = this.properties.getProperty(SOURCE_USER);
        String url = this.properties.getProperty(SOURCE_URL);
        String password = this.properties.getProperty(SOURCE_PASSWORD);
        String driverClass = this.properties.getProperty(SOURCE_DRIVER);
        if (user == null || url == null || password == null || driverClass == null) {
            throw new Exception("Properties for source connection missing!");
        }
        this.sourceConnDesc = new ConnectionDescription();
        this.sourceConnDesc.setAutoCommit(true);
        this.sourceConnDesc.setUser(user);
        this.sourceConnDesc.setUrl(url);
        this.sourceConnDesc.setPasswd(password);
        this.sourceConnDesc.setDriverClassName(driverClass);
        this.sourceConnDesc.setDefaultFetchSize(this.getFetchSize());
        this.sourceConnDesc.setPropertiesString(this.properties.getProperty(SOURCE_PROPERTIES));
        if (DatabaseSessionPool.getConnectionDescription((String)this.sourceConnDesc.getUniqueId()) == null) {
            DatabaseSessionPool.addConnectionDescription((String)this.sourceConnDesc.getUniqueId(), (ConnectionDescription)this.sourceConnDesc);
        }
        this.sourceConnection = TableTransfer.createConnection(this.sourceConnDesc);
        this.sourceConnection.setReadOnly(true);
    }

    private final void connectTarget() throws Exception {
        String user = this.properties.getProperty(TARGET_USER);
        String url = this.properties.getProperty(TARGET_URL);
        String password = this.properties.getProperty(TARGET_PASSWORD);
        String driverClass = this.properties.getProperty(TARGET_DRIVER);
        if (user == null || url == null || password == null || driverClass == null) {
            throw new Exception("Properties for target connection missing!");
        }
        this.targetConnDesc = new ConnectionDescription();
        this.targetConnDesc.setAutoCommit(false);
        this.targetConnDesc.setUser(user);
        this.targetConnDesc.setUrl(url);
        this.targetConnDesc.setPasswd(password);
        this.targetConnDesc.setDriverClassName(driverClass);
        this.targetConnDesc.setPropertiesString(this.properties.getProperty(TARGET_PROPERTIES));
        if (DatabaseSessionPool.getConnectionDescription((String)this.targetConnDesc.getUniqueId()) == null) {
            DatabaseSessionPool.addConnectionDescription((String)this.targetConnDesc.getUniqueId(), (ConnectionDescription)this.targetConnDesc);
        }
        this.targetConnection = TableTransfer.createConnection(this.targetConnDesc);
    }

    public final void setupDataModels() throws SQLException {
        this.sourceModel = this.sourceConnDesc != null ? new SQLDataModel(this.sourceConnDesc) : new SQLDataModel(this.sourceConnection);
        this.sourceModel.loadSchemas();
        this.sourceConnection.commit();
        this.targetModel = this.targetConnDesc != null ? new SQLDataModel(this.targetConnDesc) : new SQLDataModel(this.targetConnection);
        this.targetModel.loadSchemas();
        this.targetConnection.commit();
    }

    public void loadProperties(String filePath) {
        try {
            FileInputStream fis = new FileInputStream(filePath);
            this.properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            this.error("LoadProperties from " + filePath + " failed: " + e.getMessage(), e);
            this.returnCode = 1;
        }
    }

    public void setSourceURL(String url) {
        this.properties.setProperty(SOURCE_URL, url);
    }

    public String getSourceURL() {
        return this.properties.getProperty(SOURCE_URL);
    }

    public void setSourceUser(String sourceUser) {
        this.properties.setProperty(SOURCE_USER, sourceUser);
    }

    public String getSourceUser() {
        return this.properties.getProperty(SOURCE_USER);
    }

    public String getSourcePassword() {
        return this.properties.getProperty(SOURCE_PASSWORD);
    }

    public void setSourcePassword(String passwd) {
        this.properties.setProperty(SOURCE_PASSWORD, passwd);
    }

    public String getSourceDriverClass() {
        return this.properties.getProperty(SOURCE_DRIVER);
    }

    public void setSourceDriverClass(String driverClassName) {
        this.properties.setProperty(SOURCE_DRIVER, driverClassName);
    }

    public String getSourceFetchSize() {
        return this.properties.getProperty(SOURCE_FETCHSIZE);
    }

    public void setSourceFetchSize(String fetchSize) {
        this.properties.setProperty(SOURCE_FETCHSIZE, fetchSize);
    }

    public String getTargetInsertStatement() {
        return this.targetInsertStatement.getSQL();
    }

    public String getSourceQuery() {
        return this.properties.getProperty(SOURCE_QUERY);
    }

    public void setSourceQuery(String sourceQuery) {
        this.properties.setProperty(SOURCE_QUERY, sourceQuery);
    }

    public String getSourceTable() {
        return this.properties.getProperty(SOURCE_TABLE);
    }

    public void setSourceTable(String tableAndSchema) {
        this.properties.setProperty(SOURCE_TABLE, tableAndSchema);
        this.properties.remove(SOURCE_QUERY);
    }

    public String getSourceWhereClause() {
        return this.properties.getProperty(SOURCE_WHERE);
    }

    public void setSourceWhereClause(String whereClause) {
        this.properties.setProperty(SOURCE_WHERE, whereClause);
    }

    public void setSourceProperties(String propertiesString) {
        this.properties.setProperty(SOURCE_PROPERTIES, propertiesString);
    }

    public String getSourceProperties() {
        return this.properties.getProperty(SOURCE_PROPERTIES);
    }

    public void setTargetURL(String url) {
        this.properties.setProperty(TARGET_URL, url);
    }

    public String getTargetURL() {
        return this.properties.getProperty(TARGET_URL);
    }

    public void setTargetUser(String targetUser) {
        this.properties.setProperty(TARGET_USER, targetUser);
    }

    public String getTargetUser() {
        return this.properties.getProperty(TARGET_USER);
    }

    public String getTargetPassword() {
        return this.properties.getProperty(TARGET_PASSWORD);
    }

    public void setTargetPassword(String passwd) {
        this.properties.setProperty(TARGET_PASSWORD, passwd);
    }

    public String getTargetDriverClass() {
        return this.properties.getProperty(TARGET_DRIVER);
    }

    public void setTargetDriverClass(String driverClassName) {
        this.properties.setProperty(TARGET_DRIVER, driverClassName);
    }

    public String getTargetBatchSize() {
        return this.properties.getProperty(TARGET_BATCHSIZE);
    }

    public void setTargetBatchSize(String batchSize) {
        this.properties.setProperty(TARGET_BATCHSIZE, batchSize);
    }

    public String getTargetTable() {
        return this.properties.getProperty(TARGET_TABLE);
    }

    public void setTargetTable(String tableAndSchema) {
        this.properties.setProperty(TARGET_TABLE, tableAndSchema);
    }

    public void setTargetProperties(String propertiesString) {
        this.properties.setProperty(TARGET_PROPERTIES, propertiesString);
    }

    public String getTargetProperties() {
        return this.properties.getProperty(TARGET_PROPERTIES);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean isDieOnError() {
        return Boolean.parseBoolean(this.properties.getProperty(DIE_ON_ERROR, "true"));
    }

    public void setDieOnError(String dieOnError) {
        this.properties.setProperty(DIE_ON_ERROR, dieOnError);
    }

    public void setDieOnError(boolean dieOnError) {
        this.properties.setProperty(DIE_ON_ERROR, String.valueOf(dieOnError));
    }

    private final void error(String message, Exception t) {
        this.logger.error(message, t);
        this.errorMessage = message;
        this.errorException = t;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public int getCountDatabaseSessions() {
        return DatabaseSessionPool.getPoolSize();
    }

    public Connection getSourceConnection() {
        return this.sourceConnection;
    }

    public PreparedStatement getSourceStatement() {
        return this.sourcePSSelect;
    }

    public void setSourceConnection(Connection sourceConnection) {
        if (sourceConnection == null) {
            throw new IllegalArgumentException("sourceConnection cannot be null!");
        }
        this.sourceConnection = sourceConnection;
    }

    public Connection getTargetConnection() {
        return this.targetConnection;
    }

    public void setTargetConnection(Connection targetConnection) throws Exception {
        if (targetConnection == null) {
            throw new IllegalArgumentException("targetConnection cannot be null!");
        }
        if (targetConnection.isReadOnly()) {
            throw new Exception("Target connection cannot be in read only mode!");
        }
        this.targetConnection = targetConnection;
    }

    public static final double roundScale2(Double number) {
        if (number != null) {
            return (double)Math.round(number * 100.0) / 100.0;
        }
        return 0.0;
    }
}

